//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"

/*
Input-only(High impedance) 
	高阻模式只能做輸入
	
	Open drain output   	
	開漏模式具有很好的電氣相容性,外部上拉電阻接3V電源就能和3V邏輯器件接口
	適合於做電流型的驅動,其吸收電流的能力相對強(一般20mA以內).
	這種方式若不接上拉電阻時，則可以輸出高阻或低電平兩種狀態，作為輸出是一般需要外接上拉電阻的。

	Quasi-bidirectional 
	准雙向IO的最大特色是具有輸入和輸出的功能
	當IO輸出為高電平時，其驅動能力很弱，外部負載很容易將其拉至低電平
	當IO輸出為低時，其驅動能力很強，可吸收相當大的電流
	准雙向IO有三個上拉電晶體“極弱上拉”、“弱上拉”、“強上拉”。當IO作為輸入時具有一個施密特觸發器，用於抑制輸入抖動和干擾，此時鎖存器必須輸入為1。
	
	Push-pull output    	
	推挽輸出的特色是具有很強的驅動電流能力，但推挽模式只能用於輸出模式不能用於輸入模式
	
	
	//為提高晶片的抗干擾能力，降低晶片功耗，請在具體專案時，將不需要用的GPIO預設都配置為輸入上拉
*/
//********************************************************************************
//								    GPIO_INIT
//********************************************************************************
void GPIO_Init (void){
	PINSET1 = PINSET1_REGS;
	PINSET2 = PINSET2_REGS;
	PINSET3 = PINSET3_REGS;
	PINSET4 = PINSET4_REGS;
	PINSET5 = PINSET5_REGS;
	PINSET6 = PINSET6_REGS;
	PINSET7 = PINSET7_REGS;
	
	PINCONG1 = PINCONG1_REGS;
	PINCONG2 = PINCONG2_REGS;
	PINCONG3 = PINCONG3_REGS;
	PINCONG4 = PINCONG4_REGS;
	PINCONG5 = PINCONG5_REGS;
	PINCONG6 = PINCONG6_REGS;
	PINCONG7 = PINCONG7_REGS;
}
